#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) (((a) > 0) ? (a) : (-(a)))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;

const int N = 100500;

struct flower
{
	int vw, pf, vf, th;
	flower()
	{
		vw = pf = vf = th = 0;
	}

	flower(int _vw, int _pf, int _vf, int _th)
	{
		vw = _vw;
		pf = _pf;
		vf = _vf;
		th = _th;
	}
};

int n, water_cost;
flower garden[N];

double cost(double water)
{
	double res = 0.0;
	for (int i = 0; i < n; i++)
	{
		double h = water * garden[i].vw;
		double dh = garden[i].th - h;
		if ( dh <= 0 )
			continue;
		else
		{
			res += garden[i].pf * dh / garden[i].vf;
		}
	}
	return res + water_cost * water;
}

int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	
	while (true)
	{
		cin >> n;
		if (n == 0)
			break;
		cin >> water_cost;
		for (int i = 0; i < n; i++)
		{
			cin >> garden[i].vw >> garden[i].pf >> garden[i].vf >> garden[i].th;
		}

		double l, r;
		double min_cost = 1e18;

		for (int i = 0; i < 1000; i++)
		{
			double res = cost(i);
			if (res < min_cost)
			{
				min_cost = res;
				l = i;
			}
		}

		r = l + 1000.0;
		l = (l > 1000.0) ? l - 1000.0 : 0;

		while (1)
		{
			double m1 = (r - l) / 3.0 + l;
			double m2 = (r - l) / 1.5 + l;
			double q1 = cost(m1);
			double q2 = cost(m2);
			if (q1 > q2)
				l = m1;
			else
				r = m2;
			if (ABS(q1 - q2) < 1e-6 && ABS(l - r) < 1e-6)
				break;
		}
		printf("%.10lf\n", cost(l));
	}
	return 0;
}